package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait SipType {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.SipType
}
object SipType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.SipType
  ): zio.aws.alexaforbusiness.model.SipType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.SipType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SipType.WORK =>
      val r = WORK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.SipType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SipType =
      software.amazon.awssdk.services.alexaforbusiness.model.SipType.UNKNOWN_TO_SDK_VERSION
  }
  case object WORK extends zio.aws.alexaforbusiness.model.SipType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SipType =
      software.amazon.awssdk.services.alexaforbusiness.model.SipType.WORK
  }
}
