package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.SipUri
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SipAddress(
    uri: SipUri,
    `type`: zio.aws.alexaforbusiness.model.SipType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SipAddress = {
    import SipAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SipAddress
      .builder()
      .uri(SipUri.unwrap(uri): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SipAddress.ReadOnly =
    zio.aws.alexaforbusiness.model.SipAddress.wrap(buildAwsValue())
}
object SipAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SipAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SipAddress =
      zio.aws.alexaforbusiness.model.SipAddress(uri, `type`)
    def uri: SipUri
    def `type`: zio.aws.alexaforbusiness.model.SipType
    def getUri: ZIO[Any, Nothing, SipUri] = ZIO.succeed(uri)
    def getType: ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.SipType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SipAddress
  ) extends zio.aws.alexaforbusiness.model.SipAddress.ReadOnly {
    override val uri: SipUri =
      zio.aws.alexaforbusiness.model.primitives.SipUri(impl.uri())
    override val `type`: zio.aws.alexaforbusiness.model.SipType =
      zio.aws.alexaforbusiness.model.SipType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SipAddress
  ): zio.aws.alexaforbusiness.model.SipAddress.ReadOnly = new Wrapper(impl)
}
