package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  NetworkSsid,
  NetworkProfileDescription,
  NetworkProfileName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkProfileData(
    networkProfileArn: Option[Arn] = None,
    networkProfileName: Option[NetworkProfileName] = None,
    description: Option[NetworkProfileDescription] = None,
    ssid: Option[NetworkSsid] = None,
    securityType: Option[zio.aws.alexaforbusiness.model.NetworkSecurityType] =
      None,
    eapMethod: Option[zio.aws.alexaforbusiness.model.NetworkEapMethod] = None,
    certificateAuthorityArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfileData = {
    import NetworkProfileData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfileData
      .builder()
      .optionallyWith(
        networkProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkProfileArn)
      .optionallyWith(
        networkProfileName.map(value =>
          NetworkProfileName.unwrap(value): java.lang.String
        )
      )(_.networkProfileName)
      .optionallyWith(
        description.map(value =>
          NetworkProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ssid.map(value => NetworkSsid.unwrap(value): java.lang.String)
      )(_.ssid)
      .optionallyWith(securityType.map(value => value.unwrap))(_.securityType)
      .optionallyWith(eapMethod.map(value => value.unwrap))(_.eapMethod)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly =
    zio.aws.alexaforbusiness.model.NetworkProfileData.wrap(buildAwsValue())
}
object NetworkProfileData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfileData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.NetworkProfileData =
      zio.aws.alexaforbusiness.model.NetworkProfileData(
        networkProfileArn.map(value => value),
        networkProfileName.map(value => value),
        description.map(value => value),
        ssid.map(value => value),
        securityType.map(value => value),
        eapMethod.map(value => value),
        certificateAuthorityArn.map(value => value)
      )
    def networkProfileArn: Option[Arn]
    def networkProfileName: Option[NetworkProfileName]
    def description: Option[NetworkProfileDescription]
    def ssid: Option[NetworkSsid]
    def securityType: Option[zio.aws.alexaforbusiness.model.NetworkSecurityType]
    def eapMethod: Option[zio.aws.alexaforbusiness.model.NetworkEapMethod]
    def certificateAuthorityArn: Option[Arn]
    def getNetworkProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
    def getNetworkProfileName: ZIO[Any, AwsError, NetworkProfileName] =
      AwsError.unwrapOptionField("networkProfileName", networkProfileName)
    def getDescription: ZIO[Any, AwsError, NetworkProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSsid: ZIO[Any, AwsError, NetworkSsid] =
      AwsError.unwrapOptionField("ssid", ssid)
    def getSecurityType: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.NetworkSecurityType
    ] = AwsError.unwrapOptionField("securityType", securityType)
    def getEapMethod
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.NetworkEapMethod] =
      AwsError.unwrapOptionField("eapMethod", eapMethod)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfileData
  ) extends zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly {
    override val networkProfileArn: Option[Arn] = scala
      .Option(impl.networkProfileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val networkProfileName: Option[NetworkProfileName] = scala
      .Option(impl.networkProfileName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.NetworkProfileName(value)
      )
    override val description: Option[NetworkProfileDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .NetworkProfileDescription(value)
      )
    override val ssid: Option[NetworkSsid] = scala
      .Option(impl.ssid())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.NetworkSsid(value)
      )
    override val securityType
        : Option[zio.aws.alexaforbusiness.model.NetworkSecurityType] = scala
      .Option(impl.securityType())
      .map(value =>
        zio.aws.alexaforbusiness.model.NetworkSecurityType.wrap(value)
      )
    override val eapMethod
        : Option[zio.aws.alexaforbusiness.model.NetworkEapMethod] = scala
      .Option(impl.eapMethod())
      .map(value => zio.aws.alexaforbusiness.model.NetworkEapMethod.wrap(value))
    override val certificateAuthorityArn: Option[Arn] = scala
      .Option(impl.certificateAuthorityArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfileData
  ): zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly = new Wrapper(
    impl
  )
}
