package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSkillsStoreCategoriesResponse(
    categoryList: Option[Iterable[zio.aws.alexaforbusiness.model.Category]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse = {
    import ListSkillsStoreCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse
      .builder()
      .optionallyWith(
        categoryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse
      .wrap(buildAwsValue())
}
object ListSkillsStoreCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse =
      zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse(
        categoryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def categoryList
        : Option[List[zio.aws.alexaforbusiness.model.Category.ReadOnly]]
    def nextToken: Option[NextToken]
    def getCategoryList: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Category.ReadOnly
    ]] = AwsError.unwrapOptionField("categoryList", categoryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse
  ) extends zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly {
    override val categoryList
        : Option[List[zio.aws.alexaforbusiness.model.Category.ReadOnly]] = scala
      .Option(impl.categoryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Category.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse
  ): zio.aws.alexaforbusiness.model.ListSkillsStoreCategoriesResponse.ReadOnly =
    new Wrapper(impl)
}
