package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillListMaxResults,
  NextToken,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSkillsRequest(
    skillGroupArn: Option[Arn] = None,
    enablementType: Option[
      zio.aws.alexaforbusiness.model.EnablementTypeFilter
    ] = None,
    skillType: Option[zio.aws.alexaforbusiness.model.SkillTypeFilter] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[SkillListMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest = {
    import ListSkillsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .optionallyWith(enablementType.map(value => value.unwrap))(
        _.enablementType
      )
      .optionallyWith(skillType.map(value => value.unwrap))(_.skillType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => SkillListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ListSkillsRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSkillsRequest.wrap(buildAwsValue())
}
object ListSkillsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListSkillsRequest =
      zio.aws.alexaforbusiness.model.ListSkillsRequest(
        skillGroupArn.map(value => value),
        enablementType.map(value => value),
        skillType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def skillGroupArn: Option[Arn]
    def enablementType
        : Option[zio.aws.alexaforbusiness.model.EnablementTypeFilter]
    def skillType: Option[zio.aws.alexaforbusiness.model.SkillTypeFilter]
    def nextToken: Option[NextToken]
    def maxResults: Option[SkillListMaxResults]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
    def getEnablementType: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.EnablementTypeFilter
    ] = AwsError.unwrapOptionField("enablementType", enablementType)
    def getSkillType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.SkillTypeFilter] =
      AwsError.unwrapOptionField("skillType", skillType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, SkillListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
  ) extends zio.aws.alexaforbusiness.model.ListSkillsRequest.ReadOnly {
    override val skillGroupArn: Option[Arn] = scala
      .Option(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val enablementType
        : Option[zio.aws.alexaforbusiness.model.EnablementTypeFilter] = scala
      .Option(impl.enablementType())
      .map(value =>
        zio.aws.alexaforbusiness.model.EnablementTypeFilter.wrap(value)
      )
    override val skillType
        : Option[zio.aws.alexaforbusiness.model.SkillTypeFilter] = scala
      .Option(impl.skillType())
      .map(value => zio.aws.alexaforbusiness.model.SkillTypeFilter.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Option[SkillListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.SkillListMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
  ): zio.aws.alexaforbusiness.model.ListSkillsRequest.ReadOnly = new Wrapper(
    impl
  )
}
