package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConferenceProvidersResponse(
    conferenceProviders: Option[
      Iterable[zio.aws.alexaforbusiness.model.ConferenceProvider]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse = {
    import ListConferenceProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse
      .builder()
      .optionallyWith(
        conferenceProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conferenceProviders)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse
      .wrap(buildAwsValue())
}
object ListConferenceProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse =
      zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse(
        conferenceProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def conferenceProviders: Option[
      List[zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getConferenceProviders: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly
    ]] = AwsError.unwrapOptionField("conferenceProviders", conferenceProviders)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse
  ) extends zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly {
    override val conferenceProviders: Option[
      List[zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly]
    ] = scala
      .Option(impl.conferenceProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.ConferenceProvider.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse
  ): zio.aws.alexaforbusiness.model.ListConferenceProvidersResponse.ReadOnly =
    new Wrapper(impl)
}
