package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetGatewayGroupRequest(gatewayGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest = {
    import GetGatewayGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest
      .builder()
      .gatewayGroupArn(Arn.unwrap(gatewayGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetGatewayGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetGatewayGroupRequest.wrap(buildAwsValue())
}
object GetGatewayGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetGatewayGroupRequest =
      zio.aws.alexaforbusiness.model.GetGatewayGroupRequest(gatewayGroupArn)
    def gatewayGroupArn: Arn
    def getGatewayGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(gatewayGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest
  ) extends zio.aws.alexaforbusiness.model.GetGatewayGroupRequest.ReadOnly {
    override val gatewayGroupArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.gatewayGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest
  ): zio.aws.alexaforbusiness.model.GetGatewayGroupRequest.ReadOnly =
    new Wrapper(impl)
}
