package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait EnablementTypeFilter {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter
}
object EnablementTypeFilter {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter
  ): zio.aws.alexaforbusiness.model.EnablementTypeFilter = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.EnablementTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter =
      software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.alexaforbusiness.model.EnablementTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter =
      software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter.ENABLED
  }
  case object PENDING
      extends zio.aws.alexaforbusiness.model.EnablementTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter =
      software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter.PENDING
  }
}
