package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeviceStatusDetail(
    feature: Option[zio.aws.alexaforbusiness.model.Feature] = None,
    code: Option[zio.aws.alexaforbusiness.model.DeviceStatusDetailCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetail = {
    import DeviceStatusDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetail
      .builder()
      .optionallyWith(feature.map(value => value.unwrap))(_.feature)
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeviceStatusDetail.ReadOnly =
    zio.aws.alexaforbusiness.model.DeviceStatusDetail.wrap(buildAwsValue())
}
object DeviceStatusDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeviceStatusDetail =
      zio.aws.alexaforbusiness.model.DeviceStatusDetail(
        feature.map(value => value),
        code.map(value => value)
      )
    def feature: Option[zio.aws.alexaforbusiness.model.Feature]
    def code: Option[zio.aws.alexaforbusiness.model.DeviceStatusDetailCode]
    def getFeature: ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.Feature] =
      AwsError.unwrapOptionField("feature", feature)
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeviceStatusDetailCode
    ] = AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetail
  ) extends zio.aws.alexaforbusiness.model.DeviceStatusDetail.ReadOnly {
    override val feature: Option[zio.aws.alexaforbusiness.model.Feature] = scala
      .Option(impl.feature())
      .map(value => zio.aws.alexaforbusiness.model.Feature.wrap(value))
    override val code
        : Option[zio.aws.alexaforbusiness.model.DeviceStatusDetailCode] = scala
      .Option(impl.code())
      .map(value =>
        zio.aws.alexaforbusiness.model.DeviceStatusDetailCode.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetail
  ): zio.aws.alexaforbusiness.model.DeviceStatusDetail.ReadOnly = new Wrapper(
    impl
  )
}
