package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContactResponse(contactArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse = {
    import CreateContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse
      .builder()
      .optionallyWith(
        contactArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.contactArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateContactResponse.wrap(buildAwsValue())
}
object CreateContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateContactResponse =
      zio.aws.alexaforbusiness.model
        .CreateContactResponse(contactArn.map(value => value))
    def contactArn: Option[Arn]
    def getContactArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("contactArn", contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse
  ) extends zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly {
    override val contactArn: Option[Arn] = scala
      .Option(impl.contactArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse
  ): zio.aws.alexaforbusiness.model.CreateContactResponse.ReadOnly =
    new Wrapper(impl)
}
