package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{ConferenceProviderName, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConferenceProvider(
    arn: Option[Arn] = None,
    name: Option[ConferenceProviderName] = None,
    `type`: Option[zio.aws.alexaforbusiness.model.ConferenceProviderType] =
      None,
    ipDialIn: Option[zio.aws.alexaforbusiness.model.IPDialIn] = None,
    pstnDialIn: Option[zio.aws.alexaforbusiness.model.PSTNDialIn] = None,
    meetingSetting: Option[zio.aws.alexaforbusiness.model.MeetingSetting] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProvider = {
    import ConferenceProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProvider
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value =>
          ConferenceProviderName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(ipDialIn.map(value => value.buildAwsValue()))(_.ipDialIn)
      .optionallyWith(pstnDialIn.map(value => value.buildAwsValue()))(
        _.pstnDialIn
      )
      .optionallyWith(meetingSetting.map(value => value.buildAwsValue()))(
        _.meetingSetting
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly =
    zio.aws.alexaforbusiness.model.ConferenceProvider.wrap(buildAwsValue())
}
object ConferenceProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ConferenceProvider =
      zio.aws.alexaforbusiness.model.ConferenceProvider(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        ipDialIn.map(value => value.asEditable),
        pstnDialIn.map(value => value.asEditable),
        meetingSetting.map(value => value.asEditable)
      )
    def arn: Option[Arn]
    def name: Option[ConferenceProviderName]
    def `type`: Option[zio.aws.alexaforbusiness.model.ConferenceProviderType]
    def ipDialIn: Option[zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly]
    def pstnDialIn: Option[zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly]
    def meetingSetting
        : Option[zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ConferenceProviderName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.ConferenceProviderType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getIpDialIn
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly] =
      AwsError.unwrapOptionField("ipDialIn", ipDialIn)
    def getPstnDialIn: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly
    ] = AwsError.unwrapOptionField("pstnDialIn", pstnDialIn)
    def getMeetingSetting: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly
    ] = AwsError.unwrapOptionField("meetingSetting", meetingSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProvider
  ) extends zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val name: Option[ConferenceProviderName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ConferenceProviderName(value)
      )
    override val `type`
        : Option[zio.aws.alexaforbusiness.model.ConferenceProviderType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.alexaforbusiness.model.ConferenceProviderType.wrap(value)
      )
    override val ipDialIn
        : Option[zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly] = scala
      .Option(impl.ipDialIn())
      .map(value => zio.aws.alexaforbusiness.model.IPDialIn.wrap(value))
    override val pstnDialIn
        : Option[zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly] = scala
      .Option(impl.pstnDialIn())
      .map(value => zio.aws.alexaforbusiness.model.PSTNDialIn.wrap(value))
    override val meetingSetting
        : Option[zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly] = scala
      .Option(impl.meetingSetting())
      .map(value => zio.aws.alexaforbusiness.model.MeetingSetting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProvider
  ): zio.aws.alexaforbusiness.model.ConferenceProvider.ReadOnly = new Wrapper(
    impl
  )
}
