package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait SkillType {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.SkillType
}
object SkillType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.SkillType
  ): zio.aws.alexaforbusiness.model.SkillType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.SkillType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SkillType.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.SkillType.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.SkillType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SkillType =
      software.amazon.awssdk.services.alexaforbusiness.model.SkillType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.alexaforbusiness.model.SkillType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SkillType =
      software.amazon.awssdk.services.alexaforbusiness.model.SkillType.PUBLIC
  }
  case object PRIVATE extends zio.aws.alexaforbusiness.model.SkillType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.SkillType =
      software.amazon.awssdk.services.alexaforbusiness.model.SkillType.PRIVATE
  }
}
