package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchAddressBooksRequest(
    filters: Option[Iterable[zio.aws.alexaforbusiness.model.Filter]] = None,
    sortCriteria: Option[Iterable[zio.aws.alexaforbusiness.model.Sort]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest = {
    import SearchAddressBooksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        sortCriteria.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortCriteria)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SearchAddressBooksRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchAddressBooksRequest
      .wrap(buildAwsValue())
}
object SearchAddressBooksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchAddressBooksRequest =
      zio.aws.alexaforbusiness.model.SearchAddressBooksRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortCriteria.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.alexaforbusiness.model.Filter.ReadOnly]]
    def sortCriteria: Option[List[zio.aws.alexaforbusiness.model.Sort.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortCriteria: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Sort.ReadOnly
    ]] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest
  ) extends zio.aws.alexaforbusiness.model.SearchAddressBooksRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.alexaforbusiness.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Filter.wrap(item)
        }.toList
      )
    override val sortCriteria
        : Option[List[zio.aws.alexaforbusiness.model.Sort.ReadOnly]] = scala
      .Option(impl.sortCriteria())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Sort.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest
  ): zio.aws.alexaforbusiness.model.SearchAddressBooksRequest.ReadOnly =
    new Wrapper(impl)
}
