package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkEapMethod {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod
}
object NetworkEapMethod {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod
  ): zio.aws.alexaforbusiness.model.NetworkEapMethod = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod.EAP_TLS =>
      val r = EAP_TLS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.NetworkEapMethod {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object EAP_TLS extends zio.aws.alexaforbusiness.model.NetworkEapMethod {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod =
      software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod.EAP_TLS
  }
}
