package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAddressBookRequest(addressBookArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest = {
    import GetAddressBookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest
      .builder()
      .addressBookArn(Arn.unwrap(addressBookArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetAddressBookRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetAddressBookRequest.wrap(buildAwsValue())
}
object GetAddressBookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetAddressBookRequest =
      zio.aws.alexaforbusiness.model.GetAddressBookRequest(addressBookArn)
    def addressBookArn: Arn
    def getAddressBookArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(addressBookArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest
  ) extends zio.aws.alexaforbusiness.model.GetAddressBookRequest.ReadOnly {
    override val addressBookArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.addressBookArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest
  ): zio.aws.alexaforbusiness.model.GetAddressBookRequest.ReadOnly =
    new Wrapper(impl)
}
