package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  RoomSkillParameterKey,
  SkillId,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteRoomSkillParameterRequest(
    roomArn: Option[Arn] = None,
    skillId: SkillId,
    parameterKey: RoomSkillParameterKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest = {
    import DeleteRoomSkillParameterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .parameterKey(
        RoomSkillParameterKey.unwrap(parameterKey): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterRequest
      .wrap(buildAwsValue())
}
object DeleteRoomSkillParameterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterRequest =
      zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterRequest(
        roomArn.map(value => value),
        skillId,
        parameterKey
      )
    def roomArn: Option[Arn]
    def skillId: SkillId
    def parameterKey: RoomSkillParameterKey
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
    def getParameterKey: ZIO[Any, Nothing, RoomSkillParameterKey] =
      ZIO.succeed(parameterKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterRequest.ReadOnly {
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
    override val parameterKey: RoomSkillParameterKey =
      zio.aws.alexaforbusiness.model.primitives
        .RoomSkillParameterKey(impl.parameterKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest
  ): zio.aws.alexaforbusiness.model.DeleteRoomSkillParameterRequest.ReadOnly =
    new Wrapper(impl)
}
