package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait ConferenceProviderType {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType
}
object ConferenceProviderType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType
  ): zio.aws.alexaforbusiness.model.ConferenceProviderType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.CHIME =>
      val r = CHIME
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.BLUEJEANS =>
      val r = BLUEJEANS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.FUZE =>
      val r = FUZE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.GOOGLE_HANGOUTS =>
      val r = GOOGLE_HANGOUTS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.POLYCOM =>
      val r = POLYCOM
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.RINGCENTRAL =>
      val r = RINGCENTRAL
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.SKYPE_FOR_BUSINESS =>
      val r = SKYPE_FOR_BUSINESS
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.WEBEX =>
      val r = WEBEX
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.ZOOM =>
      val r = ZOOM
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object CHIME
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.CHIME
  }
  case object BLUEJEANS
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.BLUEJEANS
  }
  case object FUZE
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.FUZE
  }
  case object GOOGLE_HANGOUTS
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.GOOGLE_HANGOUTS
  }
  case object POLYCOM
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.POLYCOM
  }
  case object RINGCENTRAL
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.RINGCENTRAL
  }
  case object SKYPE_FOR_BUSINESS
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.SKYPE_FOR_BUSINESS
  }
  case object WEBEX
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.WEBEX
  }
  case object ZOOM
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.ZOOM
  }
  case object CUSTOM
      extends zio.aws.alexaforbusiness.model.ConferenceProviderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType =
      software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType.CUSTOM
  }
}
