package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BusinessReportContentRange(
    interval: zio.aws.alexaforbusiness.model.BusinessReportInterval
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportContentRange = {
    import BusinessReportContentRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportContentRange
      .builder()
      .interval(interval.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly =
    zio.aws.alexaforbusiness.model.BusinessReportContentRange
      .wrap(buildAwsValue())
}
object BusinessReportContentRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportContentRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.BusinessReportContentRange =
      zio.aws.alexaforbusiness.model.BusinessReportContentRange(interval)
    def interval: zio.aws.alexaforbusiness.model.BusinessReportInterval
    def getInterval: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.BusinessReportInterval
    ] = ZIO.succeed(interval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportContentRange
  ) extends zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly {
    override val interval
        : zio.aws.alexaforbusiness.model.BusinessReportInterval =
      zio.aws.alexaforbusiness.model.BusinessReportInterval
        .wrap(impl.interval())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportContentRange
  ): zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly =
    new Wrapper(impl)
}
