package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchUsersResponse(
    users: Option[Iterable[zio.aws.alexaforbusiness.model.UserData]] = None,
    nextToken: Option[NextToken] = None,
    totalCount: Option[TotalCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse = {
    import SearchUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchUsersResponse.wrap(buildAwsValue())
}
object SearchUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchUsersResponse =
      zio.aws.alexaforbusiness.model.SearchUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def users: Option[List[zio.aws.alexaforbusiness.model.UserData.ReadOnly]]
    def nextToken: Option[NextToken]
    def totalCount: Option[TotalCount]
    def getUsers: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.UserData.ReadOnly
    ]] = AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse
  ) extends zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly {
    override val users
        : Option[List[zio.aws.alexaforbusiness.model.UserData.ReadOnly]] = scala
      .Option(impl.users())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.UserData.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Option[TotalCount] = scala
      .Option(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse
  ): zio.aws.alexaforbusiness.model.SearchUsersResponse.ReadOnly = new Wrapper(
    impl
  )
}
