package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchNetworkProfilesResponse(
    networkProfiles: Option[
      Iterable[zio.aws.alexaforbusiness.model.NetworkProfileData]
    ] = None,
    nextToken: Option[NextToken] = None,
    totalCount: Option[TotalCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse = {
    import SearchNetworkProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse
      .builder()
      .optionallyWith(
        networkProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkProfiles)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse
      .wrap(buildAwsValue())
}
object SearchNetworkProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse =
      zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse(
        networkProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def networkProfiles: Option[
      List[zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def totalCount: Option[TotalCount]
    def getNetworkProfiles: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly
    ]] = AwsError.unwrapOptionField("networkProfiles", networkProfiles)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse
  ) extends zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly {
    override val networkProfiles: Option[
      List[zio.aws.alexaforbusiness.model.NetworkProfileData.ReadOnly]
    ] = scala
      .Option(impl.networkProfiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.NetworkProfileData.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Option[TotalCount] = scala
      .Option(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse
  ): zio.aws.alexaforbusiness.model.SearchNetworkProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
