package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSmartHomeAppliancesResponse(
    smartHomeAppliances: Option[
      Iterable[zio.aws.alexaforbusiness.model.SmartHomeAppliance]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse = {
    import ListSmartHomeAppliancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse
      .builder()
      .optionallyWith(
        smartHomeAppliances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.smartHomeAppliances)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse
      .wrap(buildAwsValue())
}
object ListSmartHomeAppliancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse =
      zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse(
        smartHomeAppliances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def smartHomeAppliances: Option[
      List[zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getSmartHomeAppliances: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly
    ]] = AwsError.unwrapOptionField("smartHomeAppliances", smartHomeAppliances)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse
  ) extends zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly {
    override val smartHomeAppliances: Option[
      List[zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly]
    ] = scala
      .Option(impl.smartHomeAppliances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.SmartHomeAppliance.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse
  ): zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesResponse.ReadOnly =
    new Wrapper(impl)
}
