package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetNetworkProfileRequest(networkProfileArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest = {
    import GetNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest
      .builder()
      .networkProfileArn(Arn.unwrap(networkProfileArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetNetworkProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetNetworkProfileRequest
      .wrap(buildAwsValue())
}
object GetNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetNetworkProfileRequest =
      zio.aws.alexaforbusiness.model.GetNetworkProfileRequest(networkProfileArn)
    def networkProfileArn: Arn
    def getNetworkProfileArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(networkProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest
  ) extends zio.aws.alexaforbusiness.model.GetNetworkProfileRequest.ReadOnly {
    override val networkProfileArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.networkProfileArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest
  ): zio.aws.alexaforbusiness.model.GetNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
