package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAddressBookResponse(
    addressBook: Option[zio.aws.alexaforbusiness.model.AddressBook] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse = {
    import GetAddressBookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse
      .builder()
      .optionallyWith(addressBook.map(value => value.buildAwsValue()))(
        _.addressBook
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetAddressBookResponse.wrap(buildAwsValue())
}
object GetAddressBookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetAddressBookResponse =
      zio.aws.alexaforbusiness.model
        .GetAddressBookResponse(addressBook.map(value => value.asEditable))
    def addressBook: Option[zio.aws.alexaforbusiness.model.AddressBook.ReadOnly]
    def getAddressBook: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.AddressBook.ReadOnly
    ] = AwsError.unwrapOptionField("addressBook", addressBook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse
  ) extends zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly {
    override val addressBook
        : Option[zio.aws.alexaforbusiness.model.AddressBook.ReadOnly] = scala
      .Option(impl.addressBook())
      .map(value => zio.aws.alexaforbusiness.model.AddressBook.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse
  ): zio.aws.alexaforbusiness.model.GetAddressBookResponse.ReadOnly =
    new Wrapper(impl)
}
