package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DisassociateSkillGroupFromRoomRequest(
    skillGroupArn: Option[Arn] = None,
    roomArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest = {
    import DisassociateSkillGroupFromRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest
      .wrap(buildAwsValue())
}
object DisassociateSkillGroupFromRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest =
      zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest(
        skillGroupArn.map(value => value),
        roomArn.map(value => value)
      )
    def skillGroupArn: Option[Arn]
    def roomArn: Option[Arn]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest
  ) extends zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest.ReadOnly {
    override val skillGroupArn: Option[Arn] = scala
      .Option(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest
  ): zio.aws.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest.ReadOnly =
    new Wrapper(impl)
}
