package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  MacAddress,
  DeviceName,
  DeviceType,
  DeviceDataCreatedTime,
  SoftwareVersion,
  Arn,
  DeviceSerialNumber,
  DeviceRoomName,
  NetworkProfileName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeviceData(
    deviceArn: Option[Arn] = None,
    deviceSerialNumber: Option[DeviceSerialNumber] = None,
    deviceType: Option[DeviceType] = None,
    deviceName: Option[DeviceName] = None,
    softwareVersion: Option[SoftwareVersion] = None,
    macAddress: Option[MacAddress] = None,
    deviceStatus: Option[zio.aws.alexaforbusiness.model.DeviceStatus] = None,
    networkProfileArn: Option[Arn] = None,
    networkProfileName: Option[NetworkProfileName] = None,
    roomArn: Option[Arn] = None,
    roomName: Option[DeviceRoomName] = None,
    deviceStatusInfo: Option[zio.aws.alexaforbusiness.model.DeviceStatusInfo] =
      None,
    createdTime: Option[DeviceDataCreatedTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceData = {
    import DeviceData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        deviceSerialNumber.map(value =>
          DeviceSerialNumber.unwrap(value): java.lang.String
        )
      )(_.deviceSerialNumber)
      .optionallyWith(
        deviceType.map(value => DeviceType.unwrap(value): java.lang.String)
      )(_.deviceType)
      .optionallyWith(
        deviceName.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        softwareVersion.map(value =>
          SoftwareVersion.unwrap(value): java.lang.String
        )
      )(_.softwareVersion)
      .optionallyWith(
        macAddress.map(value => MacAddress.unwrap(value): java.lang.String)
      )(_.macAddress)
      .optionallyWith(deviceStatus.map(value => value.unwrap))(_.deviceStatus)
      .optionallyWith(
        networkProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkProfileArn)
      .optionallyWith(
        networkProfileName.map(value =>
          NetworkProfileName.unwrap(value): java.lang.String
        )
      )(_.networkProfileName)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        roomName.map(value => DeviceRoomName.unwrap(value): java.lang.String)
      )(_.roomName)
      .optionallyWith(deviceStatusInfo.map(value => value.buildAwsValue()))(
        _.deviceStatusInfo
      )
      .optionallyWith(
        createdTime.map(value => DeviceDataCreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeviceData.ReadOnly =
    zio.aws.alexaforbusiness.model.DeviceData.wrap(buildAwsValue())
}
object DeviceData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeviceData =
      zio.aws.alexaforbusiness.model.DeviceData(
        deviceArn.map(value => value),
        deviceSerialNumber.map(value => value),
        deviceType.map(value => value),
        deviceName.map(value => value),
        softwareVersion.map(value => value),
        macAddress.map(value => value),
        deviceStatus.map(value => value),
        networkProfileArn.map(value => value),
        networkProfileName.map(value => value),
        roomArn.map(value => value),
        roomName.map(value => value),
        deviceStatusInfo.map(value => value.asEditable),
        createdTime.map(value => value)
      )
    def deviceArn: Option[Arn]
    def deviceSerialNumber: Option[DeviceSerialNumber]
    def deviceType: Option[DeviceType]
    def deviceName: Option[DeviceName]
    def softwareVersion: Option[SoftwareVersion]
    def macAddress: Option[MacAddress]
    def deviceStatus: Option[zio.aws.alexaforbusiness.model.DeviceStatus]
    def networkProfileArn: Option[Arn]
    def networkProfileName: Option[NetworkProfileName]
    def roomArn: Option[Arn]
    def roomName: Option[DeviceRoomName]
    def deviceStatusInfo
        : Option[zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly]
    def createdTime: Option[DeviceDataCreatedTime]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getDeviceSerialNumber: ZIO[Any, AwsError, DeviceSerialNumber] =
      AwsError.unwrapOptionField("deviceSerialNumber", deviceSerialNumber)
    def getDeviceType: ZIO[Any, AwsError, DeviceType] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getSoftwareVersion: ZIO[Any, AwsError, SoftwareVersion] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
    def getMacAddress: ZIO[Any, AwsError, MacAddress] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getDeviceStatus
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceStatus] =
      AwsError.unwrapOptionField("deviceStatus", deviceStatus)
    def getNetworkProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
    def getNetworkProfileName: ZIO[Any, AwsError, NetworkProfileName] =
      AwsError.unwrapOptionField("networkProfileName", networkProfileName)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getRoomName: ZIO[Any, AwsError, DeviceRoomName] =
      AwsError.unwrapOptionField("roomName", roomName)
    def getDeviceStatusInfo: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly
    ] = AwsError.unwrapOptionField("deviceStatusInfo", deviceStatusInfo)
    def getCreatedTime: ZIO[Any, AwsError, DeviceDataCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
  ) extends zio.aws.alexaforbusiness.model.DeviceData.ReadOnly {
    override val deviceArn: Option[Arn] = scala
      .Option(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val deviceSerialNumber: Option[DeviceSerialNumber] = scala
      .Option(impl.deviceSerialNumber())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceSerialNumber(value)
      )
    override val deviceType: Option[DeviceType] = scala
      .Option(impl.deviceType())
      .map(value => zio.aws.alexaforbusiness.model.primitives.DeviceType(value))
    override val deviceName: Option[DeviceName] = scala
      .Option(impl.deviceName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.DeviceName(value))
    override val softwareVersion: Option[SoftwareVersion] = scala
      .Option(impl.softwareVersion())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.SoftwareVersion(value)
      )
    override val macAddress: Option[MacAddress] = scala
      .Option(impl.macAddress())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MacAddress(value))
    override val deviceStatus
        : Option[zio.aws.alexaforbusiness.model.DeviceStatus] = scala
      .Option(impl.deviceStatus())
      .map(value => zio.aws.alexaforbusiness.model.DeviceStatus.wrap(value))
    override val networkProfileArn: Option[Arn] = scala
      .Option(impl.networkProfileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val networkProfileName: Option[NetworkProfileName] = scala
      .Option(impl.networkProfileName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.NetworkProfileName(value)
      )
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomName: Option[DeviceRoomName] = scala
      .Option(impl.roomName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceRoomName(value)
      )
    override val deviceStatusInfo
        : Option[zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly] =
      scala
        .Option(impl.deviceStatusInfo())
        .map(value =>
          zio.aws.alexaforbusiness.model.DeviceStatusInfo.wrap(value)
        )
    override val createdTime: Option[DeviceDataCreatedTime] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceDataCreatedTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
  ): zio.aws.alexaforbusiness.model.DeviceData.ReadOnly = new Wrapper(impl)
}
