package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDeviceRequest(deviceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest = {
    import DeleteDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest
      .builder()
      .deviceArn(Arn.unwrap(deviceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeleteDeviceRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteDeviceRequest.wrap(buildAwsValue())
}
object DeleteDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteDeviceRequest =
      zio.aws.alexaforbusiness.model.DeleteDeviceRequest(deviceArn)
    def deviceArn: Arn
    def getDeviceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(deviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteDeviceRequest.ReadOnly {
    override val deviceArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.deviceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest
  ): zio.aws.alexaforbusiness.model.DeleteDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
