package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait PhoneNumberType {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType
}
object PhoneNumberType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType
  ): zio.aws.alexaforbusiness.model.PhoneNumberType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.MOBILE =>
      val r = MOBILE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.WORK =>
      val r = WORK
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.HOME =>
      val r = HOME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType =
      software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.UNKNOWN_TO_SDK_VERSION
  }
  case object MOBILE extends zio.aws.alexaforbusiness.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType =
      software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.MOBILE
  }
  case object WORK extends zio.aws.alexaforbusiness.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType =
      software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.WORK
  }
  case object HOME extends zio.aws.alexaforbusiness.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType =
      software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType.HOME
  }
}
