package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MeetingRoomConfiguration(
    roomUtilizationMetricsEnabled: Option[Boolean] = None,
    endOfMeetingReminder: Option[
      zio.aws.alexaforbusiness.model.EndOfMeetingReminder
    ] = None,
    instantBooking: Option[zio.aws.alexaforbusiness.model.InstantBooking] =
      None,
    requireCheckIn: Option[zio.aws.alexaforbusiness.model.RequireCheckIn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration = {
    import MeetingRoomConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
      .builder()
      .optionallyWith(
        roomUtilizationMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.roomUtilizationMetricsEnabled)
      .optionallyWith(endOfMeetingReminder.map(value => value.buildAwsValue()))(
        _.endOfMeetingReminder
      )
      .optionallyWith(instantBooking.map(value => value.buildAwsValue()))(
        _.instantBooking
      )
      .optionallyWith(requireCheckIn.map(value => value.buildAwsValue()))(
        _.requireCheckIn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly =
    zio.aws.alexaforbusiness.model.MeetingRoomConfiguration
      .wrap(buildAwsValue())
}
object MeetingRoomConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.MeetingRoomConfiguration =
      zio.aws.alexaforbusiness.model.MeetingRoomConfiguration(
        roomUtilizationMetricsEnabled.map(value => value),
        endOfMeetingReminder.map(value => value.asEditable),
        instantBooking.map(value => value.asEditable),
        requireCheckIn.map(value => value.asEditable)
      )
    def roomUtilizationMetricsEnabled: Option[Boolean]
    def endOfMeetingReminder
        : Option[zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly]
    def instantBooking
        : Option[zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly]
    def requireCheckIn
        : Option[zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly]
    def getRoomUtilizationMetricsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "roomUtilizationMetricsEnabled",
        roomUtilizationMetricsEnabled
      )
    def getEndOfMeetingReminder: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly
    ] = AwsError.unwrapOptionField("endOfMeetingReminder", endOfMeetingReminder)
    def getInstantBooking: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly
    ] = AwsError.unwrapOptionField("instantBooking", instantBooking)
    def getRequireCheckIn: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly
    ] = AwsError.unwrapOptionField("requireCheckIn", requireCheckIn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
  ) extends zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly {
    override val roomUtilizationMetricsEnabled: Option[Boolean] = scala
      .Option(impl.roomUtilizationMetricsEnabled())
      .map(value => value: Boolean)
    override val endOfMeetingReminder
        : Option[zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly] =
      scala
        .Option(impl.endOfMeetingReminder())
        .map(value =>
          zio.aws.alexaforbusiness.model.EndOfMeetingReminder.wrap(value)
        )
    override val instantBooking
        : Option[zio.aws.alexaforbusiness.model.InstantBooking.ReadOnly] = scala
      .Option(impl.instantBooking())
      .map(value => zio.aws.alexaforbusiness.model.InstantBooking.wrap(value))
    override val requireCheckIn
        : Option[zio.aws.alexaforbusiness.model.RequireCheckIn.ReadOnly] = scala
      .Option(impl.requireCheckIn())
      .map(value => zio.aws.alexaforbusiness.model.RequireCheckIn.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.MeetingRoomConfiguration
  ): zio.aws.alexaforbusiness.model.MeetingRoomConfiguration.ReadOnly =
    new Wrapper(impl)
}
