package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{NextToken, MaxResults, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSmartHomeAppliancesRequest(
    roomArn: Arn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest = {
    import ListSmartHomeAppliancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest
      .builder()
      .roomArn(Arn.unwrap(roomArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesRequest
      .wrap(buildAwsValue())
}
object ListSmartHomeAppliancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesRequest =
      zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesRequest(
        roomArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def roomArn: Arn
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getRoomArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roomArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest
  ) extends zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesRequest.ReadOnly {
    override val roomArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.roomArn())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest
  ): zio.aws.alexaforbusiness.model.ListSmartHomeAppliancesRequest.ReadOnly =
    new Wrapper(impl)
}
