package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListGatewaysResponse(
    gateways: Option[Iterable[zio.aws.alexaforbusiness.model.GatewaySummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse = {
    import ListGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse
      .builder()
      .optionallyWith(
        gateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gateways)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListGatewaysResponse.wrap(buildAwsValue())
}
object ListGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListGatewaysResponse =
      zio.aws.alexaforbusiness.model.ListGatewaysResponse(
        gateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gateways
        : Option[List[zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getGateways: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("gateways", gateways)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse
  ) extends zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly {
    override val gateways
        : Option[List[zio.aws.alexaforbusiness.model.GatewaySummary.ReadOnly]] =
      scala
        .Option(impl.gateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.GatewaySummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse
  ): zio.aws.alexaforbusiness.model.ListGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
