package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait EnablementType {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.EnablementType
}
object EnablementType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.EnablementType
  ): zio.aws.alexaforbusiness.model.EnablementType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.EnablementType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnablementType.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EnablementType.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.EnablementType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnablementType =
      software.amazon.awssdk.services.alexaforbusiness.model.EnablementType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.alexaforbusiness.model.EnablementType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnablementType =
      software.amazon.awssdk.services.alexaforbusiness.model.EnablementType.ENABLED
  }
  case object PENDING extends zio.aws.alexaforbusiness.model.EnablementType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EnablementType =
      software.amazon.awssdk.services.alexaforbusiness.model.EnablementType.PENDING
  }
}
