package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateContactFromAddressBookRequest(
    contactArn: Arn,
    addressBookArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest = {
    import DisassociateContactFromAddressBookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest
      .builder()
      .contactArn(Arn.unwrap(contactArn): java.lang.String)
      .addressBookArn(Arn.unwrap(addressBookArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookRequest
      .wrap(buildAwsValue())
}
object DisassociateContactFromAddressBookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookRequest =
      zio.aws.alexaforbusiness.model
        .DisassociateContactFromAddressBookRequest(contactArn, addressBookArn)
    def contactArn: Arn
    def addressBookArn: Arn
    def getContactArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(contactArn)
    def getAddressBookArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(addressBookArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest
  ) extends zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookRequest.ReadOnly {
    override val contactArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.contactArn())
    override val addressBookArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.addressBookArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest
  ): zio.aws.alexaforbusiness.model.DisassociateContactFromAddressBookRequest.ReadOnly =
    new Wrapper(impl)
}
