package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.ConnectionStatusUpdatedTime
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeviceStatusInfo(
    deviceStatusDetails: Option[
      Iterable[zio.aws.alexaforbusiness.model.DeviceStatusDetail]
    ] = None,
    connectionStatus: Option[zio.aws.alexaforbusiness.model.ConnectionStatus] =
      None,
    connectionStatusUpdatedTime: Option[ConnectionStatusUpdatedTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo = {
    import DeviceStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo
      .builder()
      .optionallyWith(
        deviceStatusDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceStatusDetails)
      .optionallyWith(connectionStatus.map(value => value.unwrap))(
        _.connectionStatus
      )
      .optionallyWith(
        connectionStatusUpdatedTime.map(value =>
          ConnectionStatusUpdatedTime.unwrap(value): Instant
        )
      )(_.connectionStatusUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly =
    zio.aws.alexaforbusiness.model.DeviceStatusInfo.wrap(buildAwsValue())
}
object DeviceStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeviceStatusInfo =
      zio.aws.alexaforbusiness.model.DeviceStatusInfo(
        deviceStatusDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectionStatus.map(value => value),
        connectionStatusUpdatedTime.map(value => value)
      )
    def deviceStatusDetails: Option[
      List[zio.aws.alexaforbusiness.model.DeviceStatusDetail.ReadOnly]
    ]
    def connectionStatus
        : Option[zio.aws.alexaforbusiness.model.ConnectionStatus]
    def connectionStatusUpdatedTime: Option[ConnectionStatusUpdatedTime]
    def getDeviceStatusDetails: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.DeviceStatusDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceStatusDetails", deviceStatusDetails)
    def getConnectionStatus
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.ConnectionStatus] =
      AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getConnectionStatusUpdatedTime
        : ZIO[Any, AwsError, ConnectionStatusUpdatedTime] =
      AwsError.unwrapOptionField(
        "connectionStatusUpdatedTime",
        connectionStatusUpdatedTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo
  ) extends zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly {
    override val deviceStatusDetails: Option[
      List[zio.aws.alexaforbusiness.model.DeviceStatusDetail.ReadOnly]
    ] = scala
      .Option(impl.deviceStatusDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.DeviceStatusDetail.wrap(item)
        }.toList
      )
    override val connectionStatus
        : Option[zio.aws.alexaforbusiness.model.ConnectionStatus] = scala
      .Option(impl.connectionStatus())
      .map(value => zio.aws.alexaforbusiness.model.ConnectionStatus.wrap(value))
    override val connectionStatusUpdatedTime
        : Option[ConnectionStatusUpdatedTime] = scala
      .Option(impl.connectionStatusUpdatedTime())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .ConnectionStatusUpdatedTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo
  ): zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly = new Wrapper(
    impl
  )
}
