package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceStatusDetailCode {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode
}
object DeviceStatusDetailCode {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode
  ): zio.aws.alexaforbusiness.model.DeviceStatusDetailCode = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DEVICE_SOFTWARE_UPDATE_NEEDED =>
      val r = DEVICE_SOFTWARE_UPDATE_NEEDED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DEVICE_WAS_OFFLINE =>
      val r = DEVICE_WAS_OFFLINE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.CREDENTIALS_ACCESS_FAILURE =>
      val r = CREDENTIALS_ACCESS_FAILURE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.TLS_VERSION_MISMATCH =>
      val r = TLS_VERSION_MISMATCH
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.ASSOCIATION_REJECTION =>
      val r = ASSOCIATION_REJECTION
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.AUTHENTICATION_FAILURE =>
      val r = AUTHENTICATION_FAILURE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DHCP_FAILURE =>
      val r = DHCP_FAILURE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.INTERNET_UNAVAILABLE =>
      val r = INTERNET_UNAVAILABLE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DNS_FAILURE =>
      val r = DNS_FAILURE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.UNKNOWN_FAILURE =>
      val r = UNKNOWN_FAILURE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.CERTIFICATE_ISSUING_LIMIT_EXCEEDED =>
      val r = CERTIFICATE_ISSUING_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.INVALID_CERTIFICATE_AUTHORITY =>
      val r = INVALID_CERTIFICATE_AUTHORITY
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.NETWORK_PROFILE_NOT_FOUND =>
      val r = NETWORK_PROFILE_NOT_FOUND
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.INVALID_PASSWORD_STATE =>
      val r = INVALID_PASSWORD_STATE
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.PASSWORD_NOT_FOUND =>
      val r = PASSWORD_NOT_FOUND
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.PASSWORD_MANAGER_ACCESS_DENIED =>
      val r = PASSWORD_MANAGER_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.CERTIFICATE_AUTHORITY_ACCESS_DENIED =>
      val r = CERTIFICATE_AUTHORITY_ACCESS_DENIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.UNKNOWN_TO_SDK_VERSION
  }
  case object DEVICE_SOFTWARE_UPDATE_NEEDED
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DEVICE_SOFTWARE_UPDATE_NEEDED
  }
  case object DEVICE_WAS_OFFLINE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DEVICE_WAS_OFFLINE
  }
  case object CREDENTIALS_ACCESS_FAILURE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.CREDENTIALS_ACCESS_FAILURE
  }
  case object TLS_VERSION_MISMATCH
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.TLS_VERSION_MISMATCH
  }
  case object ASSOCIATION_REJECTION
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.ASSOCIATION_REJECTION
  }
  case object AUTHENTICATION_FAILURE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.AUTHENTICATION_FAILURE
  }
  case object DHCP_FAILURE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DHCP_FAILURE
  }
  case object INTERNET_UNAVAILABLE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.INTERNET_UNAVAILABLE
  }
  case object DNS_FAILURE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.DNS_FAILURE
  }
  case object UNKNOWN_FAILURE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.UNKNOWN_FAILURE
  }
  case object CERTIFICATE_ISSUING_LIMIT_EXCEEDED
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.CERTIFICATE_ISSUING_LIMIT_EXCEEDED
  }
  case object INVALID_CERTIFICATE_AUTHORITY
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.INVALID_CERTIFICATE_AUTHORITY
  }
  case object NETWORK_PROFILE_NOT_FOUND
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.NETWORK_PROFILE_NOT_FOUND
  }
  case object INVALID_PASSWORD_STATE
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.INVALID_PASSWORD_STATE
  }
  case object PASSWORD_NOT_FOUND
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.PASSWORD_NOT_FOUND
  }
  case object PASSWORD_MANAGER_ACCESS_DENIED
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.PASSWORD_MANAGER_ACCESS_DENIED
  }
  case object CERTIFICATE_AUTHORITY_ACCESS_DENIED
      extends zio.aws.alexaforbusiness.model.DeviceStatusDetailCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode.CERTIFICATE_AUTHORITY_ACCESS_DENIED
  }
}
