package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAddressBookRequest(addressBookArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest = {
    import DeleteAddressBookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest
      .builder()
      .addressBookArn(Arn.unwrap(addressBookArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteAddressBookRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteAddressBookRequest
      .wrap(buildAwsValue())
}
object DeleteAddressBookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteAddressBookRequest =
      zio.aws.alexaforbusiness.model.DeleteAddressBookRequest(addressBookArn)
    def addressBookArn: Arn
    def getAddressBookArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(addressBookArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteAddressBookRequest.ReadOnly {
    override val addressBookArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.addressBookArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest
  ): zio.aws.alexaforbusiness.model.DeleteAddressBookRequest.ReadOnly =
    new Wrapper(impl)
}
