package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait BusinessReportStatus {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus
}
object BusinessReportStatus {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus
  ): zio.aws.alexaforbusiness.model.BusinessReportStatus = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.BusinessReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING
      extends zio.aws.alexaforbusiness.model.BusinessReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.RUNNING
  }
  case object SUCCEEDED
      extends zio.aws.alexaforbusiness.model.BusinessReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.SUCCEEDED
  }
  case object FAILED
      extends zio.aws.alexaforbusiness.model.BusinessReportStatus {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportStatus.FAILED
  }
}
