package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  S3KeyPrefix,
  CustomerS3BucketName,
  BusinessReportScheduleName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BusinessReportSchedule(
    scheduleArn: Option[Arn] = None,
    scheduleName: Option[BusinessReportScheduleName] = None,
    s3BucketName: Option[CustomerS3BucketName] = None,
    s3KeyPrefix: Option[S3KeyPrefix] = None,
    format: Option[zio.aws.alexaforbusiness.model.BusinessReportFormat] = None,
    contentRange: Option[
      zio.aws.alexaforbusiness.model.BusinessReportContentRange
    ] = None,
    recurrence: Option[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence
    ] = None,
    lastBusinessReport: Option[zio.aws.alexaforbusiness.model.BusinessReport] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule = {
    import BusinessReportSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule
      .builder()
      .optionallyWith(
        scheduleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.scheduleArn)
      .optionallyWith(
        scheduleName.map(value =>
          BusinessReportScheduleName.unwrap(value): java.lang.String
        )
      )(_.scheduleName)
      .optionallyWith(
        s3BucketName.map(value =>
          CustomerS3BucketName.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3KeyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(contentRange.map(value => value.buildAwsValue()))(
        _.contentRange
      )
      .optionallyWith(recurrence.map(value => value.buildAwsValue()))(
        _.recurrence
      )
      .optionallyWith(lastBusinessReport.map(value => value.buildAwsValue()))(
        _.lastBusinessReport
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly =
    zio.aws.alexaforbusiness.model.BusinessReportSchedule.wrap(buildAwsValue())
}
object BusinessReportSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.BusinessReportSchedule =
      zio.aws.alexaforbusiness.model.BusinessReportSchedule(
        scheduleArn.map(value => value),
        scheduleName.map(value => value),
        s3BucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        format.map(value => value),
        contentRange.map(value => value.asEditable),
        recurrence.map(value => value.asEditable),
        lastBusinessReport.map(value => value.asEditable)
      )
    def scheduleArn: Option[Arn]
    def scheduleName: Option[BusinessReportScheduleName]
    def s3BucketName: Option[CustomerS3BucketName]
    def s3KeyPrefix: Option[S3KeyPrefix]
    def format: Option[zio.aws.alexaforbusiness.model.BusinessReportFormat]
    def contentRange: Option[
      zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly
    ]
    def recurrence: Option[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ]
    def lastBusinessReport
        : Option[zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly]
    def getScheduleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("scheduleArn", scheduleArn)
    def getScheduleName: ZIO[Any, AwsError, BusinessReportScheduleName] =
      AwsError.unwrapOptionField("scheduleName", scheduleName)
    def getS3BucketName: ZIO[Any, AwsError, CustomerS3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getFormat: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportFormat
    ] = AwsError.unwrapOptionField("format", format)
    def getContentRange: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly
    ] = AwsError.unwrapOptionField("contentRange", contentRange)
    def getRecurrence: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ] = AwsError.unwrapOptionField("recurrence", recurrence)
    def getLastBusinessReport: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly
    ] = AwsError.unwrapOptionField("lastBusinessReport", lastBusinessReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule
  ) extends zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly {
    override val scheduleArn: Option[Arn] = scala
      .Option(impl.scheduleArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val scheduleName: Option[BusinessReportScheduleName] = scala
      .Option(impl.scheduleName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .BusinessReportScheduleName(value)
      )
    override val s3BucketName: Option[CustomerS3BucketName] = scala
      .Option(impl.s3BucketName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.CustomerS3BucketName(value)
      )
    override val s3KeyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.s3KeyPrefix())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.S3KeyPrefix(value)
      )
    override val format
        : Option[zio.aws.alexaforbusiness.model.BusinessReportFormat] = scala
      .Option(impl.format())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportFormat.wrap(value)
      )
    override val contentRange: Option[
      zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly
    ] = scala
      .Option(impl.contentRange())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportContentRange.wrap(value)
      )
    override val recurrence: Option[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ] = scala
      .Option(impl.recurrence())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportRecurrence.wrap(value)
      )
    override val lastBusinessReport
        : Option[zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly] = scala
      .Option(impl.lastBusinessReport())
      .map(value => zio.aws.alexaforbusiness.model.BusinessReport.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule
  ): zio.aws.alexaforbusiness.model.BusinessReportSchedule.ReadOnly =
    new Wrapper(impl)
}
