package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait BusinessReportFormat {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat
}
object BusinessReportFormat {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat
  ): zio.aws.alexaforbusiness.model.BusinessReportFormat = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat.CSV_ZIP =>
      val r = CSV_ZIP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.BusinessReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.alexaforbusiness.model.BusinessReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat.CSV
  }
  case object CSV_ZIP
      extends zio.aws.alexaforbusiness.model.BusinessReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat.CSV_ZIP
  }
}
