package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateContactWithAddressBookRequest(
    contactArn: Arn,
    addressBookArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest = {
    import AssociateContactWithAddressBookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest
      .builder()
      .contactArn(Arn.unwrap(contactArn): java.lang.String)
      .addressBookArn(Arn.unwrap(addressBookArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookRequest
      .wrap(buildAwsValue())
}
object AssociateContactWithAddressBookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookRequest =
      zio.aws.alexaforbusiness.model
        .AssociateContactWithAddressBookRequest(contactArn, addressBookArn)
    def contactArn: Arn
    def addressBookArn: Arn
    def getContactArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(contactArn)
    def getAddressBookArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(addressBookArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest
  ) extends zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookRequest.ReadOnly {
    override val contactArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.contactArn())
    override val addressBookArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.addressBookArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest
  ): zio.aws.alexaforbusiness.model.AssociateContactWithAddressBookRequest.ReadOnly =
    new Wrapper(impl)
}
