package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillGroupDescription,
  SkillGroupName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SkillGroupData(
    skillGroupArn: Option[Arn] = None,
    skillGroupName: Option[SkillGroupName] = None,
    description: Option[SkillGroupDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupData = {
    import SkillGroupData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupData
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .optionallyWith(
        skillGroupName.map(value =>
          SkillGroupName.unwrap(value): java.lang.String
        )
      )(_.skillGroupName)
      .optionallyWith(
        description.map(value =>
          SkillGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly =
    zio.aws.alexaforbusiness.model.SkillGroupData.wrap(buildAwsValue())
}
object SkillGroupData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SkillGroupData =
      zio.aws.alexaforbusiness.model.SkillGroupData(
        skillGroupArn.map(value => value),
        skillGroupName.map(value => value),
        description.map(value => value)
      )
    def skillGroupArn: Option[Arn]
    def skillGroupName: Option[SkillGroupName]
    def description: Option[SkillGroupDescription]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
    def getSkillGroupName: ZIO[Any, AwsError, SkillGroupName] =
      AwsError.unwrapOptionField("skillGroupName", skillGroupName)
    def getDescription: ZIO[Any, AwsError, SkillGroupDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupData
  ) extends zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly {
    override val skillGroupArn: Option[Arn] = scala
      .Option(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val skillGroupName: Option[SkillGroupName] = scala
      .Option(impl.skillGroupName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.SkillGroupName(value)
      )
    override val description: Option[SkillGroupDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.SkillGroupDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupData
  ): zio.aws.alexaforbusiness.model.SkillGroupData.ReadOnly = new Wrapper(impl)
}
