package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterAvsDeviceResponse(deviceArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse = {
    import RegisterAvsDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse
      .wrap(buildAwsValue())
}
object RegisterAvsDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse =
      zio.aws.alexaforbusiness.model
        .RegisterAvsDeviceResponse(deviceArn.map(value => value))
    def deviceArn: Option[Arn]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse
  ) extends zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly {
    override val deviceArn: Option[Arn] = scala
      .Option(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse
  ): zio.aws.alexaforbusiness.model.RegisterAvsDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
