package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  SkillId,
  Email,
  OrganizationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutInvitationConfigurationRequest(
    organizationName: OrganizationName,
    contactEmail: Option[Email] = None,
    privateSkillIds: Option[Iterable[SkillId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest = {
    import PutInvitationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest
      .builder()
      .organizationName(
        OrganizationName.unwrap(organizationName): java.lang.String
      )
      .optionallyWith(
        contactEmail.map(value => Email.unwrap(value): java.lang.String)
      )(_.contactEmail)
      .optionallyWith(
        privateSkillIds.map(value =>
          value.map { item =>
            SkillId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.privateSkillIds)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.PutInvitationConfigurationRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.PutInvitationConfigurationRequest
      .wrap(buildAwsValue())
}
object PutInvitationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.PutInvitationConfigurationRequest =
      zio.aws.alexaforbusiness.model.PutInvitationConfigurationRequest(
        organizationName,
        contactEmail.map(value => value),
        privateSkillIds.map(value => value)
      )
    def organizationName: OrganizationName
    def contactEmail: Option[Email]
    def privateSkillIds: Option[List[SkillId]]
    def getOrganizationName: ZIO[Any, Nothing, OrganizationName] =
      ZIO.succeed(organizationName)
    def getContactEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("contactEmail", contactEmail)
    def getPrivateSkillIds: ZIO[Any, AwsError, List[SkillId]] =
      AwsError.unwrapOptionField("privateSkillIds", privateSkillIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest
  ) extends zio.aws.alexaforbusiness.model.PutInvitationConfigurationRequest.ReadOnly {
    override val organizationName: OrganizationName =
      zio.aws.alexaforbusiness.model.primitives
        .OrganizationName(impl.organizationName())
    override val contactEmail: Option[Email] = scala
      .Option(impl.contactEmail())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Email(value))
    override val privateSkillIds: Option[List[SkillId]] = scala
      .Option(impl.privateSkillIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.SkillId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest
  ): zio.aws.alexaforbusiness.model.PutInvitationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
