package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetConferencePreferenceResponse(
    preference: Option[zio.aws.alexaforbusiness.model.ConferencePreference] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse = {
    import GetConferencePreferenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse
      .builder()
      .optionallyWith(preference.map(value => value.buildAwsValue()))(
        _.preference
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse
      .wrap(buildAwsValue())
}
object GetConferencePreferenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse =
      zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse(
        preference.map(value => value.asEditable)
      )
    def preference
        : Option[zio.aws.alexaforbusiness.model.ConferencePreference.ReadOnly]
    def getPreference: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.ConferencePreference.ReadOnly
    ] = AwsError.unwrapOptionField("preference", preference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse
  ) extends zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly {
    override val preference
        : Option[zio.aws.alexaforbusiness.model.ConferencePreference.ReadOnly] =
      scala
        .Option(impl.preference())
        .map(value =>
          zio.aws.alexaforbusiness.model.ConferencePreference.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse
  ): zio.aws.alexaforbusiness.model.GetConferencePreferenceResponse.ReadOnly =
    new Wrapper(impl)
}
