package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  GatewayGroupDescription,
  GatewayGroupName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GatewayGroupSummary(
    arn: Option[Arn] = None,
    name: Option[GatewayGroupName] = None,
    description: Option[GatewayGroupDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroupSummary = {
    import GatewayGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroupSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => GatewayGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          GatewayGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly =
    zio.aws.alexaforbusiness.model.GatewayGroupSummary.wrap(buildAwsValue())
}
object GatewayGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GatewayGroupSummary =
      zio.aws.alexaforbusiness.model.GatewayGroupSummary(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def arn: Option[Arn]
    def name: Option[GatewayGroupName]
    def description: Option[GatewayGroupDescription]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, GatewayGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, GatewayGroupDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroupSummary
  ) extends zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val name: Option[GatewayGroupName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayGroupName(value)
      )
    override val description: Option[GatewayGroupDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayGroupDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroupSummary
  ): zio.aws.alexaforbusiness.model.GatewayGroupSummary.ReadOnly = new Wrapper(
    impl
  )
}
