package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EndOfMeetingReminder(
    reminderAtMinutes: Option[Iterable[Minutes]] = None,
    reminderType: Option[
      zio.aws.alexaforbusiness.model.EndOfMeetingReminderType
    ] = None,
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminder = {
    import EndOfMeetingReminder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminder
      .builder()
      .optionallyWith(
        reminderAtMinutes.map(value =>
          value.map { item =>
            Minutes.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.reminderAtMinutes)
      .optionallyWith(reminderType.map(value => value.unwrap))(_.reminderType)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly =
    zio.aws.alexaforbusiness.model.EndOfMeetingReminder.wrap(buildAwsValue())
}
object EndOfMeetingReminder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.EndOfMeetingReminder =
      zio.aws.alexaforbusiness.model.EndOfMeetingReminder(
        reminderAtMinutes.map(value => value),
        reminderType.map(value => value),
        enabled.map(value => value)
      )
    def reminderAtMinutes: Option[List[Minutes]]
    def reminderType
        : Option[zio.aws.alexaforbusiness.model.EndOfMeetingReminderType]
    def enabled: Option[Boolean]
    def getReminderAtMinutes: ZIO[Any, AwsError, List[Minutes]] =
      AwsError.unwrapOptionField("reminderAtMinutes", reminderAtMinutes)
    def getReminderType: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.EndOfMeetingReminderType
    ] = AwsError.unwrapOptionField("reminderType", reminderType)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminder
  ) extends zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly {
    override val reminderAtMinutes: Option[List[Minutes]] = scala
      .Option(impl.reminderAtMinutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.Minutes(item)
        }.toList
      )
    override val reminderType
        : Option[zio.aws.alexaforbusiness.model.EndOfMeetingReminderType] =
      scala
        .Option(impl.reminderType())
        .map(value =>
          zio.aws.alexaforbusiness.model.EndOfMeetingReminderType.wrap(value)
        )
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminder
  ): zio.aws.alexaforbusiness.model.EndOfMeetingReminder.ReadOnly = new Wrapper(
    impl
  )
}
