package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  MacAddress,
  DeviceName,
  DeviceType,
  SoftwareVersion,
  Arn,
  DeviceSerialNumber
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Device(
    deviceArn: Option[Arn] = None,
    deviceSerialNumber: Option[DeviceSerialNumber] = None,
    deviceType: Option[DeviceType] = None,
    deviceName: Option[DeviceName] = None,
    softwareVersion: Option[SoftwareVersion] = None,
    macAddress: Option[MacAddress] = None,
    roomArn: Option[Arn] = None,
    deviceStatus: Option[zio.aws.alexaforbusiness.model.DeviceStatus] = None,
    deviceStatusInfo: Option[zio.aws.alexaforbusiness.model.DeviceStatusInfo] =
      None,
    networkProfileInfo: Option[
      zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Device
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        deviceSerialNumber.map(value =>
          DeviceSerialNumber.unwrap(value): java.lang.String
        )
      )(_.deviceSerialNumber)
      .optionallyWith(
        deviceType.map(value => DeviceType.unwrap(value): java.lang.String)
      )(_.deviceType)
      .optionallyWith(
        deviceName.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        softwareVersion.map(value =>
          SoftwareVersion.unwrap(value): java.lang.String
        )
      )(_.softwareVersion)
      .optionallyWith(
        macAddress.map(value => MacAddress.unwrap(value): java.lang.String)
      )(_.macAddress)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(deviceStatus.map(value => value.unwrap))(_.deviceStatus)
      .optionallyWith(deviceStatusInfo.map(value => value.buildAwsValue()))(
        _.deviceStatusInfo
      )
      .optionallyWith(networkProfileInfo.map(value => value.buildAwsValue()))(
        _.networkProfileInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Device.ReadOnly =
    zio.aws.alexaforbusiness.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Device
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Device =
      zio.aws.alexaforbusiness.model.Device(
        deviceArn.map(value => value),
        deviceSerialNumber.map(value => value),
        deviceType.map(value => value),
        deviceName.map(value => value),
        softwareVersion.map(value => value),
        macAddress.map(value => value),
        roomArn.map(value => value),
        deviceStatus.map(value => value),
        deviceStatusInfo.map(value => value.asEditable),
        networkProfileInfo.map(value => value.asEditable)
      )
    def deviceArn: Option[Arn]
    def deviceSerialNumber: Option[DeviceSerialNumber]
    def deviceType: Option[DeviceType]
    def deviceName: Option[DeviceName]
    def softwareVersion: Option[SoftwareVersion]
    def macAddress: Option[MacAddress]
    def roomArn: Option[Arn]
    def deviceStatus: Option[zio.aws.alexaforbusiness.model.DeviceStatus]
    def deviceStatusInfo
        : Option[zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly]
    def networkProfileInfo: Option[
      zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo.ReadOnly
    ]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getDeviceSerialNumber: ZIO[Any, AwsError, DeviceSerialNumber] =
      AwsError.unwrapOptionField("deviceSerialNumber", deviceSerialNumber)
    def getDeviceType: ZIO[Any, AwsError, DeviceType] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getSoftwareVersion: ZIO[Any, AwsError, SoftwareVersion] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
    def getMacAddress: ZIO[Any, AwsError, MacAddress] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getDeviceStatus
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceStatus] =
      AwsError.unwrapOptionField("deviceStatus", deviceStatus)
    def getDeviceStatusInfo: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly
    ] = AwsError.unwrapOptionField("deviceStatusInfo", deviceStatusInfo)
    def getNetworkProfileInfo: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo.ReadOnly
    ] = AwsError.unwrapOptionField("networkProfileInfo", networkProfileInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Device
  ) extends zio.aws.alexaforbusiness.model.Device.ReadOnly {
    override val deviceArn: Option[Arn] = scala
      .Option(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val deviceSerialNumber: Option[DeviceSerialNumber] = scala
      .Option(impl.deviceSerialNumber())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceSerialNumber(value)
      )
    override val deviceType: Option[DeviceType] = scala
      .Option(impl.deviceType())
      .map(value => zio.aws.alexaforbusiness.model.primitives.DeviceType(value))
    override val deviceName: Option[DeviceName] = scala
      .Option(impl.deviceName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.DeviceName(value))
    override val softwareVersion: Option[SoftwareVersion] = scala
      .Option(impl.softwareVersion())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.SoftwareVersion(value)
      )
    override val macAddress: Option[MacAddress] = scala
      .Option(impl.macAddress())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MacAddress(value))
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val deviceStatus
        : Option[zio.aws.alexaforbusiness.model.DeviceStatus] = scala
      .Option(impl.deviceStatus())
      .map(value => zio.aws.alexaforbusiness.model.DeviceStatus.wrap(value))
    override val deviceStatusInfo
        : Option[zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly] =
      scala
        .Option(impl.deviceStatusInfo())
        .map(value =>
          zio.aws.alexaforbusiness.model.DeviceStatusInfo.wrap(value)
        )
    override val networkProfileInfo: Option[
      zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo.ReadOnly
    ] = scala
      .Option(impl.networkProfileInfo())
      .map(value =>
        zio.aws.alexaforbusiness.model.DeviceNetworkProfileInfo.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Device
  ): zio.aws.alexaforbusiness.model.Device.ReadOnly = new Wrapper(impl)
}
