package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{Arn, SkillId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSkillAuthorizationRequest(
    skillId: SkillId,
    roomArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest = {
    import DeleteSkillAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest
      .builder()
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationRequest
      .wrap(buildAwsValue())
}
object DeleteSkillAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationRequest =
      zio.aws.alexaforbusiness.model
        .DeleteSkillAuthorizationRequest(skillId, roomArn.map(value => value))
    def skillId: SkillId
    def roomArn: Option[Arn]
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationRequest.ReadOnly {
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest
  ): zio.aws.alexaforbusiness.model.DeleteSkillAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
