package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteProfileRequest(profileArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest = {
    import DeleteProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest
      .builder()
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeleteProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteProfileRequest.wrap(buildAwsValue())
}
object DeleteProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteProfileRequest =
      zio.aws.alexaforbusiness.model
        .DeleteProfileRequest(profileArn.map(value => value))
    def profileArn: Option[Arn]
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteProfileRequest.ReadOnly {
    override val profileArn: Option[Arn] = scala
      .Option(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest
  ): zio.aws.alexaforbusiness.model.DeleteProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
