package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSkillGroupResponse(skillGroupArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse = {
    import CreateSkillGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateSkillGroupResponse
      .wrap(buildAwsValue())
}
object CreateSkillGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateSkillGroupResponse =
      zio.aws.alexaforbusiness.model
        .CreateSkillGroupResponse(skillGroupArn.map(value => value))
    def skillGroupArn: Option[Arn]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse
  ) extends zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly {
    override val skillGroupArn: Option[Arn] = scala
      .Option(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse
  ): zio.aws.alexaforbusiness.model.CreateSkillGroupResponse.ReadOnly =
    new Wrapper(impl)
}
