package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateRequireCheckIn(
    releaseAfterMinutes: Minutes,
    enabled: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateRequireCheckIn = {
    import CreateRequireCheckIn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateRequireCheckIn
      .builder()
      .releaseAfterMinutes(Minutes.unwrap(releaseAfterMinutes): Integer)
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateRequireCheckIn.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateRequireCheckIn.wrap(buildAwsValue())
}
object CreateRequireCheckIn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateRequireCheckIn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateRequireCheckIn =
      zio.aws.alexaforbusiness.model
        .CreateRequireCheckIn(releaseAfterMinutes, enabled)
    def releaseAfterMinutes: Minutes
    def enabled: Boolean
    def getReleaseAfterMinutes: ZIO[Any, Nothing, Minutes] =
      ZIO.succeed(releaseAfterMinutes)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateRequireCheckIn
  ) extends zio.aws.alexaforbusiness.model.CreateRequireCheckIn.ReadOnly {
    override val releaseAfterMinutes: Minutes =
      zio.aws.alexaforbusiness.model.primitives
        .Minutes(impl.releaseAfterMinutes())
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateRequireCheckIn
  ): zio.aws.alexaforbusiness.model.CreateRequireCheckIn.ReadOnly = new Wrapper(
    impl
  )
}
